/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.alipay;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.alipay.LeshuaAlipayAntOrderQueryResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhangmj
 * @version LeshuaActivitySignRequest.java, v 0.1 2022-03-09 上午9:29 zhangmj
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaAlipayAntOrderQueryRequest extends LeshuaBizRequest<LeshuaAlipayAntOrderQueryResponse> {

    /**
     * 乐刷商户id
     */
    private String merchantId;

    /**
     * 支付宝返回的申请单id
     */
    private String orderId;

    @Override
    public Class<LeshuaAlipayAntOrderQueryResponse> getResponseClass() {
        return LeshuaAlipayAntOrderQueryResponse.class;
    }
}